%%
%% This is file `mersenne.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% mersenne.dtx  (with options: `class')
%% mersenne-compat.dtx  (with options: `class')
%% mersenne-util.dtx  (with options: `class')
%% mersenne-meta.dtx  (with options: `class')
%% mersenne-defaults.dtx  (with options: `class')
%% mersenne-options.dtx  (with options: `class')
%% mersenne-init.dtx  (with options: `class')
%% mersenne-authors.dtx  (with options: `class')
%% mersenne-user.dtx  (with options: `class')
%% mersenne-volume.dtx  (with options: `class')
%% mersenne-end.dtx  (with options: `class')
%% 
%% More info at https://www.centre-mersenne.org/
%% 
\NeedsTeXFormat{LaTeX2e}
\ProvidesExplClass{mersenne} {2024/11/22} {0.1} {Common class for Centre Mersenne}
\cs_generate_variant:Nn \clist_put_right:Nn { Ne }
\cs_generate_variant:Nn \file_input:n { V }
\cs_generate_variant:Nn \iow_now:Nn { Ne, NV }
\cs_generate_variant:Nn \prop_gput:Nnn { Nne }
\cs_generate_variant:Nn \prop_item:Nn { Ne, NV }
\cs_generate_variant:Nn \prop_put:Nnn { Nen }
\cs_generate_variant:Nn \seq_put_right:Nn { Ne }
\cs_generate_variant:Nn \seq_gput_right:Nn { Ne }
\cs_generate_variant:Nn \str_put_right:Nn { Ne }
\cs_generate_variant:Nn \str_set:Nn { Ne }
\cs_generate_variant:Nn \sys_shell_now:n { e }
\cs_generate_variant:Nn \tl_put_left:Nn { Ne }
\cs_generate_variant:Nn \tl_put_right:Nn { Ne }
\cs_generate_variant:Nn \tl_set:Nn { Ne }
\prg_generate_conditional_variant:Nnn \file_if_exist:n { V } { T, F, TF }
\prg_generate_conditional_variant:Nnn \str_if_eq:nn { en, ne } { T, F, TF }
\prg_generate_conditional_variant:Nnn \tl_if_eq:nn { en, ne } { T, F, TF }
\ifx\undefined\ProcessKeyOptions
  \RequirePackage{l3keys2e}
  \NewDocumentCommand \ProcessKeyOptions {O{}} {\ProcessKeysOptions{#1}}
\fi
\int_new:N \mrs_use_int
\cs_new:Nn \mrs_use:nn {
  \int_gincr:N \mrs_use_int
  \cs_new:cn {mrs_fn_\int_use:N \mrs_use_int :n} {#1}
  \tl_new:c {mrs_fn_\int_use:N \mrs_use_int _tl}
  \tl_gset:cn {mrs_fn_\int_use:N \mrs_use_int _tl} {#2}
  \exp_args:Nnv \use:c {mrs_fn_\int_use:N \mrs_use_int :n}
    {mrs_fn_\int_use:N \mrs_use_int _tl}
}
\cs_generate_variant:Nn \mrs_use:nn { ne, nv, nV }
\NewDocumentCommand {\MissingInfo} { m } {
  \ClassWarning {mersenne} {Missing ~ info: ~ #1}
  \textcolor {red} {\textbf{#1}}
}
\prg_new_conditional:Nnn \mrs_prop_key:NnN { p, T, F, TF } {
  \tl_clear:N #3
  \prop_map_inline:Nn #1 {\tl_if_eq:nnT {##2} {#2} {\tl_set:Nn #3 {##1}}}
  \tl_if_empty:NTF #3 {\prg_return_false:} {\prg_return_true:}
}
\int_new:N \mrs_ensure_int
\cs_new:Nn \mrs_prop_ensure:NnN {
  \mrs_prop_key:NnNF #1 {#2} #3 {
    \int_incr:N \mrs_ensure_int
    \tl_set:Ne #3 {\int_use:N \mrs_ensure_int}
    \prop_gput:NVn #1 #3 {#2}
  }
}
\cs_new:Nn \mrs_prop_print:Nn {
  \par \bigskip \noindent \textbf{#2} \par \smallskip
  \prop_map_inline:Nn #1 { \noindent
    \begin{tabular}{|p{.25\hsize}|p{.65\hsize}|}
      \hline \strut \texttt{##1} & {\let \\ = \par ##2} \\ \hline
    \end{tabular} \par
  }
}
\cs_generate_variant:Nn \mrs_prop_print:Nn { cn }
\cs_new:Nn \mrs_mkfile:nn {
  \iow_open:Nn \g_tmpa_iow {#1}
  \iow_now:Nn \g_tmpa_iow {#2}
  \iow_close:N \g_tmpa_iow
}
\cs_generate_variant:Nn \mrs_mkfile:nn { ne, nV }
\cs_new:Nn \mrs_mkfile_maybe:nn { \file_if_exist:nF {#1} {\cdr_mkfile:nn{#1}{#2}} }
\prg_new_conditional:Nnn \mrs_input:n { T, F, TF } {
  \tl_set:Ne \l_tmpa_tl {mersenne-\mrs_meta:n{journal}-#1}
  \file_if_exist:VTF \l_tmpa_tl
  { \file_input:V \l_tmpa_tl \prg_return_true: }
  { \prg_return_false: }
}
\cs_new:Nn \mrs_input:n {
  \mrs_input:nF {#1} {\ClassWarning {mersenne} {Include ~ file ~ \l_tmpa_tl\space not ~ present}}
}
\cs_new:Nn \mrs_input_err:n {
  \mrs_input:nF {#1} {\ClassError {mersenne} {Include ~ file ~ \l_tmpa_tl\space ~ not ~ present} {}}
}
\cs_new:Nn \mrs_tl_save:nnn { \mrs_mkfile:nn {#1/#2.var} {#3} }
\cs_generate_variant:Nn \mrs_tl_save:nnn { nnV, neV, nne }
\prg_new_conditional:Nnn \mrs_tl_load:nnN { T, F, TF } {
  \file_get:nnNTF {#1/#2.var} {\ExplSyntaxOff\makeatletter\endlinechar=-1} #3
    {\prg_return_true:} {\prg_return_false:}
}
\prg_generate_conditional_variant:Nnn \mrs_tl_load:nnN { neN } { T, F, TF }
\cs_new:Nn \mrs_meta_save:nn {
  \prop_get:NnNT \mrs_meta_prop {#2} \l_tmpa_tl {\mrs_tl_save:nnV {#1} {#2} \l_tmpa_tl}
}
\cs_new:Nn \mrs_meta_load:nn {
  \mrs_tl_load:nnNT {#1} {#2} \l_tmpa_tl {\mrs_meta_set:nV {#2} \l_tmpa_tl}
}
\prop_new:N \mrs_meta_prop
\prop_new:N \mrs_msg_prop
\cs_new:Nn \mrs_prop_put:Nnnn { \prop_gput:Nnn #1 {#2@#3} {#4} }
\cs_new:Nn \mrs_prop_put_main:Nnn { \mrs_prop_put:Nnen #1 {#2} {\mrs_meta:n {lang}} {#3} }
\cs_new:Nn \mrs_prop_put_alt:Nnn { \mrs_prop_put:Nnen #1 {#2} {\mrs_meta:n {altlang}} {#3} }
\cs_new:Nn \mrs_prop_put_EF:Nnnn {
  \mrs_prop_put:Nnnn #1 {#2} {english} {#3}
  \mrs_prop_put:Nnnn #1 {#2} {french} {#4}
}
\cs_generate_variant:Nn \mrs_prop_put:Nnnn { Nnen }
\cs_new:Nn \mrs_prop_use:Nnnn {
  \prop_if_in:NnTF #1 {#2} {\mrs_use:ne {#3} {\prop_item:Nn #1 {#2}}} {#4}
}
\cs_generate_variant:Nn \mrs_prop_use:Nnnn { Nenn }
\cs_new:Nn \mrs_prop_use_main:Nnnn {
  \mrs_prop_use:Nenn #1 {#2@\mrs_meta:n {lang}} {#3} {#4}
}
\cs_new:Nn \mrs_prop_use_main:Nn {
  \mrs_prop_use_main:Nnnn #1 {#2} {##1} {\MissingInfo{[#1]}}
}
\cs_new:Nn \mrs_prop_use_alt:Nnnn {
  \mrs_prop_use:Nenn #1 {#2@\mrs_meta:n {altlang}} {#3} {#4}
}
\cs_new:Nn \mrs_prop_use_alt:Nn {
  \mrs_prop_use_alt:Nnnn #1 {#2} {##1} {\MissingInfo{[#1]}}
}
\cs_new:Nn \mrs_prop_use_cur:Nnnn {
  \mrs_prop_use:Nenn #1 {#2@\languagename} {#3} {#4}
}
\cs_new:Nn \mrs_meta_set:nn { \prop_gput:Nnn \mrs_meta_prop {#1} {#2} }
\cs_generate_variant:Nn \mrs_meta_set:nn { ne, nx, nV, en, ee, eV }
\cs_new:Nn \mrs_meta_set_main:nn { \mrs_prop_put_main:Nnn \mrs_meta_prop {#1} {#2} }
\cs_new:Nn \mrs_meta_set_alt:nn { \mrs_prop_put_alt:Nnn \mrs_meta_prop {#1} {#2} }
\cs_new:Nn \mrs_meta_set_both:nnn {
  \mrs_prop_put_main:Nnn \mrs_meta_prop {#1} {#2}
  \mrs_prop_put_alt:Nnn \mrs_meta_prop {#1} {#3}
}
\cs_new:Nn \mrs_meta_set_EF:nnn {
  \mrs_meta_set:nn {#1@english} {#2}
  \mrs_meta_set:nn {#1@french} {#3}
}
\cs_new:Nn \mrs_msg_set:nnn { \prop_put:Nnn \mrs_msg_prop {#1@#2} {#3} }
\cs_new:Nn \mrs_msg_set_main:nn { \mrs_prop_put_main:Nnn \mrs_msg_prop {#1} {#2} }
\cs_new:Nn \mrs_msg_set_alt:nn { \mrs_prop_put_alt:Nnn \mrs_msg_prop {#1} {#2} }
\cs_new:Nn \mrs_msg_set_EF:nnn { \mrs_prop_put_EF:Nnnn \mrs_msg_prop {#1} {#2} {#3} }
\cs_new:Nn \mrs_meta:n { \prop_item:Nn \mrs_meta_prop {#1} }
\cs_new:Nn \mrs_meta_main:n { \mrs_prop_use_main:Nn \mrs_meta_prop {#1} }
\cs_new:Nn \mrs_meta_alt:n { \mrs_prop_use_alt:Nn \mrs_meta_prop {#1} }
\cs_new:Nn \mrs_meta_cur:n { \mrs_prop_use_cur:Nn \mrs_meta_prop {#1} }
\cs_new:Nn \mrs_meta_use:nnn { \mrs_prop_use:Nnnn \mrs_meta_prop {#1} {#2} {#3} }
\cs_new:Nn \mrs_meta_use_main:nnn { \mrs_prop_use_main:Nnnn \mrs_meta_prop {#1} {#2} {#3} }
\cs_new:Nn \mrs_meta_use_alt:nnn { \mrs_prop_use_alt:Nnnn \mrs_meta_prop {#1} {#2} {#3} }
\cs_new:Nn \mrs_meta_use_cur:nnn { \mrs_prop_use_cur:Nnnn \mrs_meta_prop {#1} {#2} {#3} }
\cs_new:Nn \mrs_msg_use:n
  { \mrs_prop_use_cur:Nnnn \mrs_msg_prop {#1} {##1} {\MissingInfo{[#1]}} }
\cs_new:Nn \mrs_msg_use_main:n
  { \mrs_prop_use_main:Nnnn \mrs_msg_prop {#1} {##1} {\MissingInfo{[#1]}} }
\cs_new:Nn \mrs_msg_use_alt:n
  { \mrs_prop_use_alt:Nnnn \mrs_msg_prop {#1} {##1} {\MissingInfo{[#1]}} }
\prop_new:N \mrs_lang_prop
\prop_gput:Nnn \mrs_lang_prop {english} {en}
\prop_gput:Nnn \mrs_lang_prop {french} {fr}
\NewDocumentCommand {\ItHasTeXPublished} {} { \mrs_meta_set:nn {publishTeX} {yes} }
\cs_new:Nn \mrs_use_main:n { \foreignlanguage {\mrs_meta:n {lang}} {#1} }
\cs_new:Nn \mrs_use_alt:n { \foreignlanguage {\mrs_meta:n {altlang}} {#1} }
\NewDocumentCommand {\CDRsetmeta} {mm} {\mrs_meta_set:nn {#1} {#2}}

\prop_new:N \mrs_lic_url_prop
\prop_gput:Nnn \mrs_lic_url_prop {ccbynd3} {http://creativecommons.org/licenses/by-nd/3.0/}
\prop_gput:Nnn \mrs_lic_url_prop {ccbynd3fr} {http://creativecommons.org/licenses/by-nd/3.0/fr/}
\prop_gput:Nnn \mrs_lic_url_prop {ccby4} {http://creativecommons.org/licenses/by/4.0/}
\prop_gput:Nnn \mrs_lic_url_prop {ccbyncnd4} {http://creativecommons.org/licenses/by-nc-nd/4.0/}
\prop_gput:Nnn \mrs_lic_url_prop {ccbyncsa4} {http://creativecommons.org/licenses/by-nc-sa/4.0/}
\prop_gput:Nnn \mrs_lic_url_prop {ccbynd4fr} {http://creativecommons.org/licenses/by-nd/4.0/fr/}
\bool_new:N \mrs_attached_bool
\bool_new:N \mrs_biblatex_bool
\bool_new:N \mrs_efirst_bool
\bool_new:N \mrs_meta_bool
\bool_new:N \mrs_pagedegarde_bool
\bool_new:N \mrs_prod_bool
\bool_new:N \mrs_publishtex_bool
\bool_new:N \mrs_translate_bool
\bool_new:N \mrs_volume_bool
\tl_new:N \mrs_deftralics_tl
\tl_new:N \mrs_pagenumbering_tl
\seq_new:N \mrs_afteraddr_seq
\mrs_meta_set:nn {articletype} {research-article}
\mrs_meta_set:nn {license} {ccby4}
\mrs_meta_set:nn {lang} {english}
\mrs_meta_set:nn {altlang} {french}
\mrs_meta_set:nn {baseurl} {https://www.centre-mersenne.org/}
\RequirePackage {xcolor}
\definecolor {mrs-accent} {HTML} {F5981A} % OA Orange
\keys_define:nn { mrs / options } {
  % Various boolean options
  attached    .bool_set:N = \mrs_attached_bool,    % This document is supplementary material
  biblatex    .bool_set:N = \mrs_biblatex_bool,    % This article uses biblatex
  efirst      .bool_set:N = \mrs_efirst_bool,      % This is an Online First version
  meta        .bool_set:N = \mrs_meta_bool,        % Typeset a page listing all metadata
  pagedegarde .bool_set:N = \mrs_pagedegarde_bool, % Typeset a cover page
  prod        .bool_set:N = \mrs_prod_bool,        % We are typesetting within a volume
  volume      .bool_set:N = \mrs_volume_bool,      % We are typesetting a volume driver file

  % Unknown options are stored as metadata
  unknown .code:n = \prop_put:NVn \mrs_meta_prop \l_keys_key_tl {#1}
}

\ProcessKeyOptions [ mrs / options ]

\bool_if:NT \mrs_volume_bool { \bool_set_true:N \mrs_prod_bool }
\file_if_exist:nT { \jobname.cfg } { \bool_set_true:N \mrs_prod_bool }
\file_if_exist:nT { meta/prod.var } { \bool_set_true:N \mrs_prod_bool }
\bool_if:NT \mrs_prod_bool { \AtEndOfClass{\RequirePackage{mersenne-prod}} }

\prop_if_in:NnF \mrs_meta_prop {journal}
  { \ClassError {mersenne} {Please ~ set ~ the ~ `journal` ~ option} {} \stop }
\file_if_exist_input:nF {mersenne-\mrs_meta:n{journal}.clo}
  { \ClassError {mersenne} {Journal ~ unknown: ~ \mrs_meta:n{journal}} {} \stop}

\tl_if_eq:enF { \mrs_meta:n {lang} } {english}
  { \mrs_meta_set:nn {altlang} {english} }
\LoadClass{amsart}

\file_if_exist_input:nF {mersenne-\mrs_meta:n {lang}.lng}
  {\ClassWarning {mersenne} {Unknown ~ language: ~ \mrs_meta:n {lang}} {}}
\file_if_exist_input:nF {mersenne-\mrs_meta:n {altlang}.lng}
  {\ClassWarning {mersenne} {Unknown ~ language: ~ \mrs_meta:n {altlang}} {}}

\RequirePackage{geometry}
\RequirePackage[\mrs_meta:n {altlang},\mrs_meta:n {lang}]{babel}
\bool_if:NT \mrs_biblatex_bool { \RequirePackage{biblatex} }

\RequirePackage{mathtools}
\RequirePackage[absolute]{textpos}
\RequirePackage{graphicx}
\RequirePackage{url}
\RequirePackage{lastpage}
\RequirePackage{longtable}
\RequirePackage{csquotes}
\RequirePackage[useregional]{datetime2}
\RequirePackage{fancyhdr}
\RequirePackage{setspace}
\RequirePackage{nfssext-cfr}
\RequirePackage[final,tracking]{microtype}
\RequirePackage{ifplatform}
\RequirePackage{shellesc}
\RequirePackage{changepage}
\RequirePackage[T1]{fontenc}

\key@ifundefined{MT}{nopatch}{}{\microtypesetup{nopatch=footnote}}

\AtBeginDocument{
  \hypersetup{allcolors=mrs-accent}
}
\int_new:N \mrs_nauthors_int
\int_new:N \mrs_ncontrib_int
\int_new:N \mrs_curraddr_int
\seq_new:N \mrs_authors_seq
\prop_new:N \mrs_addresses_prop
\cs_new:Nn \mrs_ensure_address:nN {
  \prop_if_in:NnTF \mrs_addresses_prop {#1} {\tl_set:Nn #2 {#1}}
    { \mrs_prop_ensure:NnN \mrs_addresses_prop {#1} #2 }
}
\cs_new:Nn \mrs_add_author:Nnn {
  \clist_clear:N \l_tmpa_clist
  \clist_clear:N \l_tmpb_clist
  \keys_define:nn {cedram/author} {
    corresponding . code:n     = \prop_gput:Nnn #1 {author-role} {corresponding},
    equal-contrib . code:n     = \prop_gput:Nnn #1 {equal-contrib} {yes},
    dead          . code:n     = \prop_gput:Nnn #1 {dead} {yes},
    orcid         . prop_put:N = #1,
    curraddr      . prop_put:N = #1,
    url           . prop_put:N = #1,
    email         . code:n     = \clist_gput_right:Nn \l_tmpb_clist {##1},
    address       . code:n     = \mrs_ensure_address:nN {##1} \l_tmpa_tl
                                 \clist_gput_right:NV \l_tmpa_clist \l_tmpa_tl,
  }
  \keys_set:nn {cedram/author} {#2}
  \prop_gput:Nnn #1 {name} {#3}
  \prop_gput:NnV #1 {addresses} \l_tmpa_clist
  \prop_gput:NnV #1 {email} \l_tmpb_clist
  \group_begin: % Extract name parts, and check that name is well-formed.
    \def\firstname##1{\prop_gput:Nnn #1 {prenom} {##1}\ignorespaces}
    \def\middlename##1{\prop_gput:Nnn #1 {middlename} {##1}\ignorespaces}
    \def\lastname##1{\prop_gput:Nnn #1 {nom} {##1}\ignorespaces}
    \def\junior##1{\prop_gput:Nnn #1 {junior} {##1}\ignorespaces}
    \def\vonname##1{\prop_gput:Nnn #1 {particule} {##1}\ignorespaces}
    \def\nobreakauthor{}
    \hbox_set:Nn \l_tmpa_box {#3}
    \dim_compare:nNnT {0pt} < {\box_wd:N \l_tmpa_box}
      {\ClassWarning{cedram}{Malformed ~ name ~ "#3"}}
  \group_end:
}
\cs_generate_variant:Nn \mrs_add_author:Nnn { cnn }
\cs_new:Nn \mrs_add_author:nn {
  \int_gincr:N \mrs_nauthors_int
  \seq_gput_right:Ne \mrs_authors_seq {\int_use:N \mrs_nauthors_int}
  \prop_new:c {mrs_author_\int_use:N \mrs_nauthors_int _prop}
  \mrs_add_author:cnn {mrs_author_\int_use:N \mrs_nauthors_int _prop} {#1} {#2}
}
\NewDocumentCommand {\addaddress} {m m} { \prop_put:Nen \mrs_addresses_prop {#1} {#2} }
\NewDocumentCommand {\addauthor} {O{} m} { \mrs_add_author:nn {#1} {#2} }
\NewDocumentCommand {\firstname} {m} {#1}
\NewDocumentCommand {\middlename} {m} {#1}
\NewDocumentCommand {\lastname} {m} {#1}
\NewDocumentCommand {\junior} {m} {#1}
\NewDocumentCommand {\vonname} {m} {#1}
\NewDocumentCommand {\nobreakauthor} {} {\nobreakspace}
\RenewDocumentCommand {\author} {m} {
  \ClassError {mersenne} {\string\author\space is ~ deprecated, ~ please ~ use ~ \string\addauthor} {}
}
\RenewDocumentCommand {\address} {m} {
  \ClassError {mersenne} {\string\address\space is ~ deprecated, ~ please ~ use ~ \string\addauthor} {}
}
\RenewDocumentCommand {\email} {m} {
  \ClassError {mersenne} {\string\email\space is ~ deprecated, ~ please ~ use ~ \string\addauthor} {}
}
\def\@@and{~ \mrs_msg_use:n{and} ~}
\tl_new:N \mrs_theauthors_tl
\AtBeginDocument {
  \seq_clear:N \l_tmpa_seq
  \seq_map_inline:Nn \mrs_authors_seq
    {\seq_put_right:Ne \l_tmpa_seq {\prop_item:cn {mrs_author_#1_prop} {name}}}
  \tl_set:Ne \mrs_theauthors_tl {\seq_use:Nnnn \l_tmpa_seq {\@@and{}} {, ~} {\@@and{}}}
}
\AtBeginDocument {
  \prop_new:N \mrs_addresses_labels_prop
  \int_set:Nn \l_tmpa_int {1}
  \prop_map_inline:Nn \mrs_addresses_prop {
    \prop_gput:Nne \mrs_addresses_labels_prop {#1} {\int_to_alph:n {\int_use:N \l_tmpa_int}}
    \int_incr:N \l_tmpa_int
  }
  \prop_new:N \mrs_addresses_numbers_prop
  \int_set:Nn \l_tmpa_int {1}
  \prop_map_inline:Nn \mrs_addresses_prop {
    \prop_gput:Nne \mrs_addresses_numbers_prop {#1} {\int_use:N \l_tmpa_int}
    \int_incr:N \l_tmpa_int
  }
}
\cs_new:Nn \mrs_authorlist:Nnnn {
  \group_begin:
    \seq_clear:N \l_tmpa_seq
    \seq_map_inline:Nn \mrs_authors_seq {
      \seq_put_right:Nn \l_tmpa_seq { \exp_args:Nc #1 {mrs_author_##1_prop} }
    }
    \seq_use:Nnnn \l_tmpa_seq {#2} {#3} {#4}
  \group_end:
}
\cs_new:Nn \mrs_author_name:N { \prop_item:Nn #1 {name} }
\RenewDocumentCommand {\maketitle} {} {
  \thispagestyle {empty}
  \cs_if_exist_use:N \mrs_typeset_head:
  \cs_if_exist_use:N \mrs_maketitle:
}

\NewDocumentCommand {\DOI} {m} { \mrs_meta_set:nn {DOI} {#1} }

\NewDocumentCommand {\printDOI} {} {
  \mrs_meta_use:nnn {DOI} {\url{https://doi.org/##1}} {\MissingInfo{No ~ DOI}}
}

\RenewDocumentCommand {\issueinfo} {mmmm} {
  \prop_put:Nnn \mrs_meta_prop {volume} {#1}
  \prop_put:Nnn \mrs_meta_prop {issue} {#2}
  \str_if_eq:nnF {#3} {} { \prop_put:Nnn \mrs_meta_prop {month} {#3} }
  \prop_put:Nnn \mrs_meta_prop {year} {#4}
}

\def\pageinfo{\mrs_meta:n {pagedeb} \pageinfosep \mrs_meta:n {pagefin}}

\def\pageinfosep{-}

\RenewDocumentCommand {\title} { O{#2} m } {
  \mrs_meta_set_main:nn {title} {#2}
  \mrs_meta_set_main:nn {shorttitle} {#1}
}

\NewDocumentCommand {\alttitle} { O{#2} m } {
  \mrs_meta_set_alt:nn {title} {#2}
  \mrs_meta_set_alt:nn {shorttitle} {#1}
}

\NewDocumentCommand {\subtitle} { O{#2} m } {
  \mrs_meta_set_main:nn {subtitle} {#2}
}

\NewDocumentCommand {\altsubtitle} { O{#2} m } {
  \mrs_meta_set_alt:nn {subtitle} {#2}
}

\RenewDocumentCommand {\dedicatory} { O{\relax} m } {
  \mrs_meta_set:nn {dedicatoryquote} {#1}
  \mrs_meta_set:nn {dedicatory} {#2}
}

\NewDocumentCommand {\editornote} { O{Note} m } {
  \mrs_meta_set_main:nn {editornotename} {#1}
  \mrs_meta_set_main:nn {editornote} {#2}
}

\NewDocumentCommand {\alteditornote} { O{Note} m } {
  \mrs_meta_set_alt:nn {editornotename} {#1}
  \mrs_meta_set_alt:nn {editornote} {#2}
}

\NewDocumentCommand   {\datereceived}  {m} { \mrs_meta_set:nn {date_reception}   {#1} }
\NewDocumentCommand   {\daterevised}   {m} { \mrs_meta_set:nn {date_revision}    {#1} }
\NewDocumentCommand   {\datererevised} {m} { \mrs_meta_set:nn {date_rerevision}  {#1} }
\NewDocumentCommand   {\dateaccepted}  {m} { \mrs_meta_set:nn {date_acceptation} {#1} }
\RenewDocumentCommand {\dateposted}    {m} { \mrs_meta_set:nn {date_online}      {#1} }
\NewDocumentCommand   {\datepublished} {m} { \mrs_meta_set:nn {date_published}   {#1} }

\cs_new:Nn \mrs_afteraddr_add:nn { \seq_gput_right:Nn \mrs_afteraddr_seq {{#1}{#2}} }

\NewDocumentCommand {\MRSafteraddr} { m m } { \mrs_afteraddr_add:nn {#1} {#2} }

\RenewDocumentEnvironment {abstract} {+b} { \mrs_meta_set_main:nn {abstract} {#1} } {}

\NewDocumentEnvironment {altabstract} {+b} { \mrs_meta_set_alt:nn {abstract} {#1} } {}

\newsavebox \kwdbox
\seq_new:N \mrs_keywords_seq
\seq_new:N \mrs_altkeywords_seq

\RenewDocumentCommand {\keywords} {m} {
  \seq_clear:N \mrs_keywords_seq
  \group_begin:
    \def\kwd##1{\seq_gput_right:Nn \mrs_keywords_seq {##1}}
    \sbox \kwdbox {#1}
    \seq_if_empty:NT \mrs_keywords_seq {\seq_gset_split:Nnn \mrs_keywords_seq {, ~} {#1}}
    \tl_clear:N \l_tmpa_tl
    \seq_map_inline:Nn \mrs_keywords_seq {\tl_gput_right:Nn \l_tmpa_tl {\kwd{##1}}}
    \mrs_meta_set:eV {keywords@\mrs_meta:n {lang}} \l_tmpa_tl
  \group_end:
  \mrs_afteraddr_add:nn {\mrs_msg_use_main:n {keywords}} {\seq_use:Nn \mrs_keywords_seq {, ~}.}
}

\NewDocumentCommand {\altkeywords} {m} {
  \seq_clear:N \mrs_altkeywords_seq
  \group_begin:
    \def\kwd##1{\seq_gput_right:Nn \mrs_altkeywords_seq {##1}}
    \sbox \kwdbox {#1}
    \seq_if_empty:NT \mrs_altkeywords_seq {\seq_gset_split:Nnn \mrs_altkeywords_seq {, ~} {#1}}
    \tl_clear:N \l_tmpa_tl
    \seq_map_inline:Nn \mrs_altkeywords_seq {\tl_gput_right:Nn \l_tmpa_tl {\kwd{##1}}}
    \mrs_meta_set:eV {keywords@\mrs_meta:n {altlang}} \l_tmpa_tl
  \group_end:
  \bool_if:NT \mrs_translate_bool
    { \mrs_afteraddr_add:nn {\mrs_msg_use_alt:n {keywords}} {\seq_use:Nn \mrs_altkeywords_seq {, ~}.} }
}

\RenewDocumentCommand {\subjclass} { O{2020} m } {
  \mrs_meta_set:nn {msc} {#2}
  \mrs_afteraddr_add:nn {#1 ~ \mrs_msg_use_main:n {msc}} {#2.}
}

\RenewDocumentCommand {\thanks} {m} {
  \mrs_meta_set:nn {thanks} {#1}
  \mrs_afteraddr_add:nn {\mrs_msg_use_main:n {thanks}} {#1}
}

\NewDocumentCommand {\fundings} {m} {
  \mrs_meta_set:nn {fundings} {#1}
  \mrs_afteraddr_add:nn {\mrs_msg_use_main:n {fundings}} {#1}
}

\NewDocumentEnvironment {DefTralics} {+b} {
  \tl_gset:Nn \mrs_deftralics_tl {#1}
}{}

\NewDocumentCommand {\setpage} {O{arabic} m} {
  \pagenumbering {#1}
  \tl_gset:Nn \mrs_pagenumbering_tl {#1}
  \setcounter {page} {#2}
  \mrs_meta_set:nn {pagedeb} {#2}
  \bool_if:NT \mrs_prod_bool {
    \mrs_tl_save:nne {meta} {pagedeb} {\thepage}
  }
}

\NewDocumentCommand {\AfterAbstract} {mm} {
  \mrs_afteraddr_add:nn {#1} {#2}
}

\newcounter{allthms}

\NewDocumentCommand{\newmersennetheorem}{ m m m m }{
  \theoremstyle{#2}
  \newtheorem{#1}[#3]{\mrs_msg_use_main:n{#4}}
  \newtheorem*{#1*}{\mrs_msg_use_main:n{#4}}
  % si un style n'existe pas, plain est utilisé, donc on peut définir aussi les
  % versions coupées, même pour les revues n'en ayant pas.
  \theoremstyle{#2c}
  \newtheorem{#1c}[#3]{\mrs_msg_use_main:n{#4}}
  \newtheorem*{#1c*}{\mrs_msg_use_main:n{#4}}
}

\NewDocumentEnvironment{enonce}{ O{plain} m }
  { \let\mrsenonce\relax
    \theoremstyle{#1}
    \newtheorem{mrsenonce}[allthms]{#2}
    \begin{mrsenonce} }
  { \end{mrsenonce} }

\NewDocumentEnvironment{enonce*}{ O{plain} m }
  { \let\mrsenonce\relax
    \theoremstyle{#1}
    \newtheorem*{mrsenonce}{#2}
    \begin{mrsenonce} }
  { \end{mrsenonce} }

\NewDocumentCommand{\equalenv}{ m m }{
  \@ifundefined{#1}
    {\newenvironment{#1}{\begin{#2}}{\end{#2}}}
    {\ClassWarningNoLine{\@classname}{
      #1 ~ already ~ defined: ~ I ~ won't ~ redefine ~ it!}}}

%%%%% TODO all these are temporary hacks.

\NewDocumentCommand {\ScreenMode} {} {
  \ClassWarning {mersenne} {\string\ScreenMode\space does ~ nothing.}
}
\newcounter{article}
\NewDocumentCommand {\TopicEF} { m m } {
  \mrs_meta_set:nn {topic@english} {#1}
  \mrs_meta_set:nn {topic@french} {#2}
}
\NewDocumentCommand {\TopicEN} { m } {
  \mrs_meta_set:nn {topic@english} {#1}
}
\NewDocumentCommand {\TopicFR} { m } {
  \mrs_meta_set:nn {topic@french} {#1}
}
\seq_new:N \mrs_funders_seq
\seq_new:N \mrs_grants_seq
\NewDocumentCommand {\CDRGrant} {O{} m} {
  \seq_gput_right:Nn \mrs_funders_seq {#1}
  \seq_gput_right:Nn \mrs_grants_seq {#2}
}
\NewDocumentCommand {\kwd} {m} {#1 \par}
\NewDocumentCommand {\tralicstex} {mm} {#2}
\bool_if:NT \mrs_volume_bool {
\RequirePackage{pdfpages}

\seq_new:N \mrs_articles_seq
\tl_new:N \mrs_som_title_english_tl
\tl_new:N \mrs_som_pagedeb_tl
\tl_new:N \mrs_som_pagefin_tl
\tl_new:N \mrs_pagestart_tl
\clist_new:N \mrs_som_authors_clist

\ior_new:N \mrs_fls_ior
\str_new:N \mrs_fls_str
\tl_new:N \mrs_fls_tl
\cs_new:Nn \mrs_fls_parse:nn {
  \ior_open:NnT \mrs_fls_ior {#1/#2.fls} {
    \ior_str_map_variable:NNn \mrs_fls_ior \mrs_fls_str {
      \str_if_eq:enT {\str_range:Nnn \mrs_fls_str {1} {5}} {INPUT} {
        \tl_set:Ne \mrs_fls_tl {\str_range:Nnn \mrs_fls_str {7} {-1}}
        \tl_if_eq:enF {\tl_head:N \mrs_fls_tl} {/} {\tl_put_left:Nn \mrs_fls_tl {#1/}}
        \typeout{(\mrs_fls_tl)}
      }
    }
  }
}

\cs_new:Nn \mrs_compile:nn {
  \sys_shell_now:e {mkdir ~ -p ~ #1/meta}
  \mrs_tl_save:nne {#1/meta} {pagedeb} {\thepage}
  \mrs_tl_save:nne {#1/meta} {prod} {yes}
  \mrs_meta_save:nn {#1/meta} {year}
  \mrs_meta_save:nn {#1/meta} {volume}
  \mrs_meta_save:nn {#1/meta} {issue}
  % \ifcdr@published\def\cdr@draftmode{ -draftmode }\else\def\cdr@draftmode{}\fi
  \ifluatex \def\cdr@pdfmode{ ~ -pdflua ~ } \else \def\cdr@pdfmode{ ~ -pdf ~ } \fi
  \def\cdr@draftmode{}
  \sys_shell_now:e {latexmk ~ \cdr@pdfmode ~ -enable-write18 ~ -interaction=nonstopmode ~
    -recorder ~ -cd ~ \cdr@draftmode ~ #1/#2 ~ 2>&1}
  \sys_shell_now:e {cd ~ #1; ~ dopax.sh ~ #2}
  \mrs_fls_parse:nn {#1} {#2}
  % \cdr@parsefls[#1]{#2}
}

\NewDocumentCommand {\IssueInfo} {mmmm} {
  \mrs_meta_set:nn {volume} {#1}
  \mrs_meta_set:nn {issue} {#2}
  \str_if_eq:nnF {#3} {} { \prop_put:Nnn \mrs_meta_prop {month} {#3} }
  \mrs_meta_set:nn {year} {#4}
}

\NewDocumentCommand {\SetFirstPage} {m} { \mrs_meta_set:nn {pagedeb} {#1} }

\NewDocumentCommand {\makefront} {} { \ClassWarning {mersenne} {\string\makefront\space is ~ deprecated} }
\NewDocumentCommand {\makeback} {} { \ClassWarning {mersenne} {\string\makeback\space is ~ deprecated} }

\AddToHook{begindocument/end}{
  \mrs_input:n {couv1} \newpage
  \mrs_input:n {couv2} \newpage
  \mrs_input:nF {front} {} \cleardoublepage
  \prop_get:NnNT \mrs_meta_prop {pagedeb} \l_tmpa_tl {\exp_args:NnV \setcounter {page} \l_tmpa_tl}
}

\AtEndDocument {
  \mrs_input:nF {back} {} \newpage
  \mrs_input:n {couv3} \newpage
  \mrs_input:n {couv4} \newpage
  \mrs_input:nF {spine} {} \newpage
}

\NewDocumentCommand {\includearticle} {m} {
  % \tkki=\@xp{\cdr@inclart}%
  % \cdr@mkfile{#2/#2.cfg}{\the\tkkv\the\tkkp{\thepage}\the\tkki\string\setcounter{article}{\the\c@article}\the\cdr@specialtitret\the\tkef}
  \cleardoublepage
  \mrs_compile:nn {#1} {#1}
  \mrs_tl_load:nnNF {#1/meta} {pagestart} \mrs_pagestart_tl {}
  \protected@write\@auxout{}{
    \ExplSyntaxOn \seq_gput_right:Nn \string\mrs_articles_seq {#1} \ExplSyntaxOff
  }
  \includepdf[pages={\mrs_pagestart_tl-},noautoscale,link=true]{#1/#1.pdf}
}

\AtBeginDocument {
  \pagestyle{empty} \thispagestyle{empty}
  \group_begin:
    \tl_set:Ne \l_tmpa_tl {\jobname-cdrxml.xml \space}
    \seq_map_inline:Nn \mrs_articles_seq {
      \tl_put_right:Ne \l_tmpa_tl {\space #1/#1-cdrxml.xml}
    }
    \mrs_mkfile:nV {\jobname.xml-list} \l_tmpa_tl
  \group_end:
}

}
\AtEndDocument {
  \cs_if_exist_use:N \mrs_makeend:
  \clearpage
}
\file_if_exist_input:n {mersenne-\mrs_meta:n{journal}.sty}
\file_if_exist_input:n {./\jobname.cfg}
\file_if_exist_input:n {./\jobname.cdrdoidates}
\file_if_exist_input:n {./\jobname.ptf}

\RequirePackage[colorlinks=true]{hyperref}

\mrs_meta_load:nn {meta} {pagedeb}
\mrs_meta_load:nn {meta} {year}
\mrs_meta_load:nn {meta} {volume}
\mrs_meta_load:nn {meta} {issue}

\AddToHook{begindocument/end}{
  \prop_map_inline:Nn \mrs_meta_prop { % #1=key, #2=value
    \str_if_in:nnT {#1} {@french} {
      \tl_set_rescan:Nnn \l_tmpa_tl {\ExplSyntaxOff} {#2}
      \prop_gput:NnV \mrs_meta_prop {#1} \l_tmpa_tl
    }
  }

  \tl_if_exist:NT \lastpage@lastpage { \mrs_meta_set:nV {pagefin} \lastpage@lastpageHy }

  \bool_if:NT \mrs_pagedegarde_bool {
    \thispagestyle{empty}
    \mrs_input_err:n {pagedegarde}
    \newpage
  }

  \bool_if:NT \mrs_meta_bool {
    \bgroup
      \pagestyle{empty}
      \centerline {\fbox{\Large \textbf{Document ~ Metadata}}} \par \vfill
      \footnotesize
      \noindent \mrs_prop_print:Nn \mrs_meta_prop {} \vfill
      \newpage
      \centerline {\fbox{\Large \textbf{Author ~ metadata}}} \par \vfill
      \mrs_prop_print:Nn \mrs_addresses_prop {Addresses}
      \seq_map_inline:Nn \mrs_authors_seq {
        \prop_get:cnN {mrs_author_#1_prop} {name} \l_tmpa_tl
        \mrs_prop_print:cn {mrs_author_#1_prop}
          {Author ~ #1 : ~ {\tl_use:N \l_tmpa_tl} ~ --- ~ \texttt{\tl_to_str:N \l_tmpa_tl}}
      }
      \vfill \newpage
      \pagestyle{plain}
    \egroup
  }

  \newpage
  \prop_get:NnNT \mrs_meta_prop {pagedeb} \l_tmpa_tl {\exp_args:NnV \setcounter {page} \l_tmpa_tl}
  \mrs_meta_set:ne {pagestart} {\int_eval:n {\ReadonlyShipoutCounter+1}}
}
